/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters.imagehandlers;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;

public abstract class AppleImage {
    private String fileExtension;
    private String[] availableExtensions;

    public static AppleImage create(int width, int height) {
        String[] classes = new String[]{"ImageIoImage", "SunJpegImage", "SwtImage"};
        Class[] constructorArgClasses = new Class[]{Integer.TYPE, Integer.TYPE};
        Object[] constructorArgs = new Object[]{new Integer(width), new Integer(height)};
        for (int i = 0; i < classes.length; ++i) {
            try {
                Class<?> appleImageClass = Class.forName("com.webcodepro.applecommander.storage.filters.imagehandlers." + classes[i]);
                Constructor<?> constructor = appleImageClass.getConstructor(constructorArgClasses);
                AppleImage appleImage = (AppleImage)constructor.newInstance(constructorArgs);
                return appleImage;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public AppleImage(String[] availableExtensions) {
        this.setAvailableExtensions(availableExtensions);
        this.setFileExtension(this.getDefaultExtension());
    }

    public String getDefaultExtension() {
        return this.getAvailableExtensions()[0];
    }

    public String[] getAvailableExtensions() {
        return this.availableExtensions;
    }

    protected void setAvailableExtensions(String[] availableExtensions) {
        this.availableExtensions = availableExtensions;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public abstract void setPoint(int var1, int var2, int var3);

    public abstract int getPoint(int var1, int var2);

    public abstract void save(OutputStream var1) throws IOException;

    public abstract int getWidth();

    public abstract int getHeight();
}

